/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.core.interpreter;

import com.aptana.core.logging.IdeLog;
import com.aptana.php.debug.PHPDebugPlugin;
import com.aptana.php.debug.core.interpreter.IInterpreter;
import com.aptana.php.debug.core.interpreter.IInterpreterProvider;
import com.aptana.php.debug.core.interpreter.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class Interpreters {
    private static final String EXTENSION_POINT_NAME = "com.aptana.php.debug.interpreterProvider";
    private static final String PROVIDER_ELEMENT_NAME = "provider";
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    private static final String LANGUAGE_ATTRIBUTE_NAME = "lang";
    private static final String PRIORITY_ATTRIBUTE_NAME = "priority";
    private static final String OS_ATTRIBUTE_NAME = "OpSystem";
    private static Interpreters instance;
    private Map<String, List<IInterpreter>> interpreters;
    private Map<String, DefaultInterpreterInfo> defaultInterpreters;

    public static Interpreters getDefault() {
        if (instance == null) {
            instance = new Interpreters();
        }
        return instance;
    }

    public synchronized List<IInterpreter> getInterpreters(String language) {
        this.collectInterpretersInfo();
        List<IInterpreter> result = this.interpreters.get(language);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public synchronized IInterpreter getDefaultInterpreter(String language) {
        this.collectInterpretersInfo();
        DefaultInterpreterInfo info = this.defaultInterpreters.get(language);
        if (info == null) {
            return null;
        }
        return info.interperter;
    }

    private void collectInterpretersInfo() {
        this.interpreters = new HashMap<String, List<IInterpreter>>();
        this.defaultInterpreters = new HashMap<String, DefaultInterpreterInfo>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(EXTENSION_POINT_NAME);
        if (ep != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = ep.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    String elementName = element.getName();
                    if (elementName.equals(PROVIDER_ELEMENT_NAME)) {
                        String language = element.getAttribute(LANGUAGE_ATTRIBUTE_NAME);
                        String os = element.getAttribute(OS_ATTRIBUTE_NAME);
                        if (os == null || Platform.getOS().equals(os)) {
                            int priority = 0;
                            String priorityString = element.getAttribute(PRIORITY_ATTRIBUTE_NAME);
                            if (priorityString != null) {
                                try {
                                    priority = Integer.parseInt(priorityString);
                                }
                                catch (NumberFormatException ex) {
                                    IdeLog.logError((Plugin)PHPDebugPlugin.getDefault(), (String)MessageFormat.format(Messages.Interpreters_priorityFormatError, elementName), (Throwable)ex, (String)"com.aptana.php.debug/debug");
                                }
                            }
                            try {
                                IInterpreterProvider provider = (IInterpreterProvider)element.createExecutableExtension(CLASS_ATTRIBUTE_NAME);
                                try {
                                    DefaultInterpreterInfo oldInfo;
                                    List<IInterpreter> currentInterpreters = provider.getInterpreters();
                                    List<IInterpreter> oldInterpreters = this.interpreters.get(language);
                                    if (oldInterpreters == null) {
                                        oldInterpreters = new ArrayList<IInterpreter>();
                                    }
                                    oldInterpreters.addAll(currentInterpreters);
                                    this.interpreters.put(language, oldInterpreters);
                                    IInterpreter defaultInterpreter = provider.getDefaultInterpreter();
                                    if (defaultInterpreter != null && ((oldInfo = this.defaultInterpreters.get(language)) == null || oldInfo.priority < priority)) {
                                        DefaultInterpreterInfo newInfo = new DefaultInterpreterInfo();
                                        newInfo.priority = priority;
                                        newInfo.interperter = defaultInterpreter;
                                        this.defaultInterpreters.put(language, newInfo);
                                    }
                                }
                                catch (Throwable th) {
                                    IdeLog.logError((Plugin)PHPDebugPlugin.getDefault(), (String)Messages.Interpreters_cannotGetInterpretersError, (Throwable)th, (String)"com.aptana.php.debug/debug");
                                }
                            }
                            catch (CoreException e) {
                                IdeLog.logError((Plugin)PHPDebugPlugin.getDefault(), (String)Messages.Interpreters_providerCreationError, (Throwable)e, (String)"com.aptana.php.debug/debug");
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private Interpreters() {
    }

    private static class DefaultInterpreterInfo {
        public IInterpreter interperter;
        public int priority;

        private DefaultInterpreterInfo() {
        }
    }
}

